import { Link, useLocation } from 'react-router-dom'
import { Music } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <>
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Music size={44} strokeWidth={2.5} className="logo-icon" />
              <span className="logo-text">DanceFlow</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои занятия
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main>{children}</main>
      <Footer />
    </>
  )
}

export default Layout

